/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is FireDictionary.
 *
 * The Initial Developer of the Original Code is 
 * Noriaki Hamamoto <nori@firedictionary.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 
/**
 * A class for words history.
 */
function FDWordHistory(){
	var unicodeConverter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
	var sidebar = top.document.getElementById("sidebar");
	var charset = "UTF-8";
	unicodeConverter.charset = charset;
	
	/**
	 * initialize()
	 *  Load the words which is stored to history file.
	 */
	this.initialize = function(){
		var file = getHistoryFile();
		
		if( file.exists() ){
			var istream = new FDInputStream(file.getFile());
			istream.setCharset(charset);
			setText(istream.readAsUnicode());
			
		} else {
			file.create();
			
		}
	}
	
	/**
	 * registWord(String keyword, String result)
	 */
	this.registWord = function(keyword, result){		
		addText(history(keyword, result));
		getHistoryFile().write(unicodeConverter.ConvertFromUnicode(getText()));
	}
	
	/**
	 * clear()
	 *  Clear the history and delete the history file.
	 */
	this.clear = function(){
		setText("");
		getHistoryFile().remove();
	}
	
	//
 // Private method ///////////////////////////////////////////////////////
 //
 
 function setText(s){
 	sidebar.contentDocument.getElementById("dictionary-result-history").value = s;
 }
 
 function getText(){
 	return sidebar.contentDocument.getElementById("dictionary-result-history").value;
 }
 
 function addText(s){
 	setText(s + getText());
 }
 
 /**
  * String history(String keyword, String result)
  *
  * @param keyword Dictionary keyword.
  * @paran result Result of dictionary.
  * @return Strings to be registed to history.
  */
 function history(keyword, result){
 	return "[ " + keyword + " ]\n  " +
	        result + "\n" +
	        "-----------------------------------------\n";
 }
 
 /**
  * FDFile getHistoryFile()
  *  Return a file instance of 'history.txt'
  *
  * @return a file instance of 'History.txt'
  */
 function getHistoryFile(){
  var dir = new FDDirectory("ProfD");
  dir.changeDirectory("FireDictionary");
  return dir.createFileInstance("history.txt"); 	
 }	
}